/********************************************************************
 * FileName:		FTP_private.h		
 * Dependencies:
 * Processor:				
 * Hardware:		
 * Assembler:		
 * Linker:		
 * Company:		Microchip Technology, Inc.
 *
 * Software License Agreement:
 * The software supplied herewith by Microchip Technology Incorporated
 * (the CompanyE for its PICmicro Microcontroller is intended and
 * supplied to you, the Companys customer, for use solely and
 * exclusively on Microchip PICmicro Microcontroller products. The
 * software is owned by the Company and/or its supplier, and is
 * protected under applicable copyright laws. All rights are reserved.
 * Any use in violation of the foregoing restrictions may subject the
 * user to criminal sanctions under applicable laws, as well as to
 * civil liability for the breach of the terms and conditions of this
 * license.
 *
 * THIS SOFTWARE IS PROVIDED IN AN AS ISECONDITION. NO WARRANTIES,
 * WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED
 * TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,
 * IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 *
 *********************************************************************
 * File Description:
 *
 * FTP Server
 *
 * Change History:
 * Name				Date            Changes
 * Sean Justice		03/10/06		Initial Version
 ********************************************************************/

#define FTP_TX_BUF_SIZE					64
#define FTP_USER_NAME_LEN				(16)

typedef enum _SM_FTP
{
    SM_FTP_NOT_CONNECTED,
    SM_FTP_CONNECTED,
    SM_FTP_USER_NAME,
    SM_FTP_USER_PASS,
    SM_FTP_RESPOND
} SM_FTP;


/************************************************************************
 * private defines
 ************************************************************************/
#define FTP_COMMAND_PORT                (21)
#define FTP_DATA_PORT                   (20)
#define FTP_TIMEOUT                     (180 * TICK_SECOND)
#define MAX_FTP_ARGS                    (7)
#define MAX_FTP_CMD_STRING_LEN          (31)
/************************************************************************
 * private enumerations
 ************************************************************************/
typedef enum _SM_FTP_CMD
{
    SM_FTP_CMD_IDLE,
    SM_FTP_CMD_WAIT,
    SM_FTP_CMD_RX_TX,
    SM_FTP_CMD_RX_TX_RETRY,
    SM_FTP_CMD_WAIT_FOR_DISCONNECT
} SM_FTP_CMD;

typedef enum _FTP_COMMAND
{
    FTP_CMD_USER,
    FTP_CMD_PASS,
    FTP_CMD_QUIT,
    FTP_CMD_STOR,
    FTP_CMD_PORT,
    FTP_CMD_ABORT,
	FTP_CMD_SYST,
	FTP_CMD_NOOP,
	FTP_CMD_PWD,
	FTP_CMD_TYPE,
	FTP_CMD_RETR,
	FTP_CMD_DELE,
	FTP_CMD_NLST,
	FTP_CMD_LIST,
	FTP_CMD_CWD,
	FTP_CMD_RMD,
	FTP_CMD_MKD,
	FTP_CMD_PASV,
    FTP_CMD_UNKNOWN,
    FTP_CMD_NONE,
} FTP_COMMAND;

typedef enum _FTP_RESPONSE
{
    FTP_RESP_BANNER = 0,
    FTP_RESP_USER_OK,
    FTP_RESP_PASS_OK,
    FTP_RESP_QUIT_OK,
    FTP_RESP_STOR_OK,
    FTP_RESP_UNKNOWN,
    FTP_RESP_LOGIN,
    FTP_RESP_DATA_OPEN,
    FTP_RESP_DATA_READY,
    FTP_RESP_DATA_CLOSE,
    FTP_RESP_OK,
	FTP_RESP_SYST,
	FTP_RESP_ASCII,
	FTP_RESP_DIRECTORY,
	FTP_RESP_DELETE,
	FTP_RESP_LIST,
	FTP_RESP_LIST_DONE,
	FTP_RESP_CWD,
	FTP_RESP_PASV,
	FTP_RESP_PORT,

    FTP_RESP_NONE                       // This must always be the last
                                        // There is no corresponding string.
} FTP_RESPONSE;

/************************************************************************
 * private unions
 ************************************************************************/
typedef union
{
	struct
	{
		BYTE	bUserSupplied:	1;
		BYTE	bLoggedIn:		1;
		BYTE	bSpare:			6;
	}Bits;
	BYTE	Val;
}FTP_FLAGS;

